<?php
/**
 * Form Initialization - CSRF Token and Timing Setup
 * Include this at the top of pages with contact forms
 */

session_start();

// Generate CSRF token if not exists
if (!isset($_SESSION['csrf_token'])) {
    $_SESSION['csrf_token'] = bin2hex(random_bytes(32));
}

// Record form load time for timing check
$_SESSION['form_loaded_time'] = time();

// Function to output CSRF token input
function outputCsrfToken() {
    return '<input type="hidden" name="csrf_token" value="' . htmlspecialchars($_SESSION['csrf_token']) . '">';
}

// Function to output honeypot fields (hidden from users, visible to bots)
function outputHoneypotFields() {
    return '
    <!-- Honeypot fields - do not remove -->
    <div style="position: absolute; left: -9999px; width: 1px; height: 1px; overflow: hidden;">
        <input type="text" name="website" tabindex="-1" autocomplete="off">
        <input type="text" name="url" tabindex="-1" autocomplete="off">
        <input type="text" name="company" tabindex="-1" autocomplete="off">
    </div>
    ';
}
?>
