#!/bin/bash
# ==============================================================================
# File Permission Fix Script for Namecheap
# ==============================================================================
# This script fixes file permissions for your website
# Run this in Namecheap cPanel Terminal (if SSH access is available)
# ==============================================================================

echo "=========================================="
echo "Fixing File Permissions for InfiniteLoop"
echo "=========================================="
echo ""

# Navigate to public_html
cd ~/public_html

echo "Step 1: Setting folder permissions to 755..."
chmod 755 css
chmod 755 js
chmod 755 images
chmod 755 images/clients
chmod 755 images/logo
echo "✓ Folders set to 755"
echo ""

echo "Step 2: Setting CSS file permissions to 644..."
find css -type f -exec chmod 644 {} \;
echo "✓ CSS files set to 644"
echo ""

echo "Step 3: Setting JS file permissions to 644..."
find js -type f -exec chmod 644 {} \;
echo "✓ JS files set to 644"
echo ""

echo "Step 4: Setting image permissions to 644..."
find images -type f -exec chmod 644 {} \;
echo "✓ Image files set to 644"
echo ""

echo "Step 5: Setting HTML file permissions to 644..."
chmod 644 *.html
echo "✓ HTML files set to 644"
echo ""

echo "Step 6: Setting .htaccess permission to 644..."
if [ -f .htaccess ]; then
    chmod 644 .htaccess
    echo "✓ .htaccess set to 644"
else
    echo "⚠ .htaccess not found (this is OK if you removed it)"
fi
echo ""

echo "Step 7: Verifying permissions..."
echo ""
echo "CSS folder:"
ls -ld css
echo ""
echo "Sample CSS file:"
ls -l css/*.css | head -1
echo ""
echo "JS folder:"
ls -ld js
echo ""
echo "Sample JS file:"
ls -l js/*.js | head -1
echo ""

echo "=========================================="
echo "✓ DONE! Permissions have been fixed."
echo "=========================================="
echo ""
echo "Next steps:"
echo "1. Clear your browser cache (Ctrl+Shift+R)"
echo "2. Test your website"
echo "3. Check browser console (F12) for errors"
echo ""
