# Namecheap Deployment Troubleshooting Guide

## Problem: Theme Not Loading (CSS/JS Files Getting 403 Errors)

### Root Cause
The `.htaccess` security rules were blocking CSS and JavaScript files, causing 403 Forbidden errors.

### Solution Applied
Updated `.htaccess` to explicitly allow static assets (CSS, JS, images, fonts) before any blocking rules.

---

## Step-by-Step Deployment to Namecheap

### 1. Prepare Your Files Locally

**Files to Upload:**
- `index.html`
- `about.html`
- `projects.html`
- `.htaccess` (IMPORTANT - this controls security and routing)
- Entire `css/` folder with all CSS files
- Entire `js/` folder with all JS files
- Entire `images/` folder with all images
- `php-email-form-secure.php` (if using contact form)
- `form-init.php` (if using contact form)

**Files/Folders to EXCLUDE (do NOT upload):**
- `.git/` folder
- `.DS_Store` files
- `node_modules/` (if you have one)
- Any local development files

### 2. Access Namecheap File Manager or FTP

**Option A: Using Namecheap File Manager**
1. Log into your Namecheap account
2. Go to cPanel
3. Click "File Manager"
4. Navigate to `public_html` folder

**Option B: Using FTP Client (Recommended)**
1. Download FileZilla or Cyberduck
2. Get FTP credentials from Namecheap cPanel
3. Connect to your server

**FTP Connection Details:**
- Host: Usually `ftp.yourdomain.com` or your server IP
- Username: Your cPanel username
- Password: Your cPanel password
- Port: 21 (FTP) or 22 (SFTP - more secure)

### 3. Upload Files

**IMPORTANT Upload Order:**
1. First, upload `.htaccess` file to `public_html/`
2. Upload all HTML files (index.html, about.html, projects.html)
3. Upload entire `css/` folder
4. Upload entire `js/` folder
5. Upload entire `images/` folder
6. Upload PHP files (if using contact form)

**File Upload Checklist:**
```
public_html/
├── .htaccess ✓
├── index.html ✓
├── about.html ✓
├── projects.html ✓
├── php-email-form-secure.php ✓
├── form-init.php ✓
├── css/
│   ├── animate.css ✓
│   ├── bootstrap.css ✓
│   ├── icomoon.css ✓
│   ├── style.css ✓
│   ├── superfish.css ✓
│   ├── mobile-responsive.css ✓
│   └── modern-enhancements.css ✓
├── js/
│   ├── bootstrap.min.js ✓
│   ├── jquery.min.js ✓
│   ├── main.js ✓
│   ├── modernizr-2.6.2.min.js ✓
│   ├── modern-features.js ✓
│   ├── form-security.js ✓
│   └── [all other JS files] ✓
└── images/
    ├── favicon.ico ✓
    ├── dd.png ✓
    └── [all other images] ✓
```

### 4. Set Correct File Permissions

**Using File Manager or FTP:**

**Folders should be 755:**
- `public_html/` → 755
- `css/` → 755
- `js/` → 755
- `images/` → 755

**Files should be 644:**
- All `.html` files → 644
- All `.css` files → 644
- All `.js` files → 644
- All image files → 644

**Special files:**
- `.htaccess` → 644
- `.php` files → 644 (or 640 for extra security)

**How to Change Permissions in FileZilla:**
1. Right-click on file/folder
2. Select "File Permissions"
3. Enter the numeric value (755 or 644)

### 5. Verify .htaccess is Working

**Test URL:** `https://yourdomain.com/.htaccess`

**Expected Result:** You should get a 403 Forbidden error (this is GOOD - means .htaccess is protecting itself)

**If you see the .htaccess file content:** This means Apache is not processing .htaccess files. Contact Namecheap support.

### 6. Common Issues and Solutions

#### Issue 1: CSS/JS Files Getting 403 Errors

**Error in Browser Console:**
```
Failed to load resource: the server responded with a status of 403 ()
modern-features.js:1
form-security.js:1
modern-enhancements.css:1
mobile-responsive.css:1
```

**Solution:**
- Make sure the UPDATED `.htaccess` file is uploaded (with static asset allow rules at the top)
- Check file permissions: CSS files should be 644, css folder should be 755
- Clear browser cache (Ctrl+Shift+R or Cmd+Shift+R)

#### Issue 2: "Internal Server Error" (500 Error)

**Possible Causes:**
1. `.htaccess` syntax error
2. Server doesn't support certain modules

**Solution:**
1. Rename `.htaccess` to `.htaccess.backup`
2. Create a new minimal `.htaccess`:
```apache
# Minimal .htaccess for testing
Options -Indexes

<FilesMatch "\.(css|js|jpg|jpeg|png|gif|svg|webp|ico)$">
    Allow from all
</FilesMatch>
```
3. Test if site loads
4. Gradually add back security rules

#### Issue 3: Images/CSS Not Loading (Mixed Content)

**Symptoms:**
- Site loads but no styling
- Browser console shows "Mixed Content" warnings

**Solution:**
Make sure all your asset links use relative paths (not absolute with http://)

**Check your HTML:**
- ✓ CORRECT: `<link rel="stylesheet" href="css/style.css">`
- ✗ WRONG: `<link rel="stylesheet" href="http://yourdomain.com/css/style.css">`

#### Issue 4: HTTPS Redirect Loop

**Symptoms:** Page keeps redirecting infinitely

**Solution:**
1. Open `.htaccess`
2. Comment out the HTTPS redirect (lines 55-57):
```apache
# RewriteCond %{HTTPS} off
# RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```
3. Only enable HTTPS redirect AFTER you've installed SSL certificate in Namecheap

#### Issue 5: File Names Are Case-Sensitive

**IMPORTANT:** Namecheap uses Linux servers, which are case-sensitive!

- `Style.css` ≠ `style.css`
- `Images/logo.png` ≠ `images/logo.png`

**Solution:**
1. Use all lowercase for folder and file names
2. Make sure HTML references match EXACTLY
3. Check: `href="css/mobile-responsive.css"` matches the actual filename

### 7. Enable SSL Certificate (HTTPS)

**Steps in Namecheap:**
1. Go to cPanel
2. Find "SSL/TLS Status" or "Let's Encrypt SSL"
3. Click "Install" or "Enable" for your domain
4. Wait 5-10 minutes for activation

**After SSL is Active:**
1. Uncomment the HTTPS redirect in `.htaccess` (lines 55-57)
2. Update canonical URL in HTML meta tags to use `https://`

### 8. Testing Checklist

After deployment, test these:

- [ ] Homepage loads correctly (`https://yourdomain.com`)
- [ ] All CSS is applied (check in browser DevTools)
- [ ] All JavaScript works (no errors in browser console)
- [ ] All images display correctly
- [ ] Mobile responsive design works
- [ ] Contact form works (if applicable)
- [ ] All navigation links work
- [ ] About page loads (`https://yourdomain.com/about.html`)
- [ ] Projects page loads (`https://yourdomain.com/projects.html`)
- [ ] No 404 errors in browser console
- [ ] No 403 errors in browser console

### 9. Browser DevTools Debugging

**How to Check for Errors:**

1. **Google Chrome:**
   - Press `F12` or `Ctrl+Shift+I` (Windows) / `Cmd+Option+I` (Mac)
   - Go to "Console" tab
   - Look for red error messages

2. **Check Network Tab:**
   - Press `F12` → Go to "Network" tab
   - Refresh page (`Ctrl+R` or `F5`)
   - Look for any red items (failed requests)
   - Click on failed items to see status code (403, 404, 500, etc.)

3. **Common Error Codes:**
   - **403 Forbidden:** File is blocked by .htaccess or permissions
   - **404 Not Found:** File doesn't exist or wrong path
   - **500 Internal Server Error:** .htaccess syntax error or server issue
   - **Mixed Content:** HTTPS page loading HTTP resources

### 10. Optimization After Deployment

**Enable Gzip Compression:**
Already included in `.htaccess` - no action needed

**Browser Caching:**
Already included in `.htaccess` - assets cached for 1 year

**Test Website Speed:**
- Google PageSpeed Insights: https://pagespeed.web.dev/
- GTmetrix: https://gtmetrix.com/

**Monitor Security:**
- Check security headers: https://securityheaders.com/
- SSL test: https://www.ssllabs.com/ssltest/

### 11. Contact Form Setup (If Using PHP Forms)

**Required Files:**
- `php-email-form-secure.php`
- `form-init.php`

**Steps:**
1. Upload both PHP files to `public_html/`
2. Edit `php-email-form-secure.php` and update:
   - `$receiving_email_address = 'your@email.com';`
3. Set file permissions to 644
4. Test form submission

**If form doesn't work:**
1. Check PHP is enabled in Namecheap (it should be by default)
2. Check error logs in cPanel → Error Log
3. Make sure email address in PHP file is correct

### 12. Namecheap-Specific Tips

**Clear Server Cache:**
- Some Namecheap servers cache files
- Wait 5-10 minutes after upload for changes to appear
- Or use cPanel → "Clear Cache" if available

**Check PHP Version:**
- cPanel → Select PHP Version
- Recommended: PHP 7.4 or 8.0+

**Database Setup (if needed later):**
- cPanel → MySQL Databases
- Create database and user
- Note credentials for future use

### 13. Emergency Rollback

**If something goes wrong:**

1. **Disable .htaccess temporarily:**
   - Rename `.htaccess` to `.htaccess.disabled`
   - Test if site loads

2. **Restore previous version:**
   - Namecheap keeps backups in cPanel
   - cPanel → Backups → Restore

3. **Download current files:**
   - Before making changes, download a backup
   - File Manager → Select All → Compress → Download

---

## Quick Fix Commands

**If still getting 403 on CSS/JS after upload:**

Add this to the VERY TOP of `.htaccess`:

```apache
<FilesMatch "\.(css|js)$">
    Require all granted
    Allow from all
</FilesMatch>
```

**If HTTPS redirect causing issues:**

Comment out these lines in `.htaccess`:

```apache
# RewriteCond %{HTTPS} off
# RewriteRule ^(.*)$ https://%{HTTP_HOST}%{REQUEST_URI} [L,R=301]
```

**If getting 500 errors:**

Replace entire `.htaccess` with this minimal version:

```apache
Options -Indexes

<FilesMatch "\.(css|js|jpg|jpeg|png|gif|svg|webp|ico|woff|woff2|ttf)$">
    Require all granted
</FilesMatch>
```

---

## Support Contacts

**Namecheap Support:**
- Live Chat: Available 24/7 in cPanel
- Email: support@namecheap.com
- Phone: Check Namecheap website for current number

**Common Questions to Ask Support:**
1. "Is mod_rewrite enabled on my hosting account?"
2. "Can you check if .htaccess files are being processed?"
3. "What PHP version is my account using?"
4. "Can you check error logs for my domain?"

---

## Final Checklist Before Going Live

- [ ] All files uploaded with correct names (case-sensitive!)
- [ ] `.htaccess` uploaded and working
- [ ] File permissions set correctly (755 for folders, 644 for files)
- [ ] SSL certificate installed and active
- [ ] Tested on desktop browser
- [ ] Tested on mobile browser
- [ ] Contact form tested (if applicable)
- [ ] No console errors in browser DevTools
- [ ] All pages accessible (index, about, projects)
- [ ] Favicon displays correctly
- [ ] SEO meta tags in place
- [ ] Google Analytics added (if using)

---

## Success Indicators

Your site is properly deployed when:

✓ Homepage loads with full styling
✓ No 403 or 404 errors in browser console
✓ Mobile responsive design works perfectly
✓ All images and icons display
✓ Navigation works between pages
✓ Contact form sends emails
✓ HTTPS is active (green padlock in browser)
✓ Page loads fast (under 3 seconds)

---

**Last Updated:** 2025-12-20
**For:** InfiniteLoop Innovations Website Deployment
